/*
 * Decompiled with CFR 0.152.
 */
package terrariachestrandomizer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import terrariachestrandomizer.TerrariaUtil;

public class TerrariaChest {
    private int xCoord;
    private int yCoord;
    private byte[] name;
    private short[] amounts;
    private int[] items;
    private byte[] mods;

    public TerrariaChest(int x, int y, byte[] nom, short[] amts, int[] it, byte[] md) {
        if (amts.length != 40 || it.length != 40 || md.length != 40) {
            System.out.println("BAD LENGTHS: " + amts.length + ", " + it.length + ", " + md.length);
            throw new IllegalArgumentException();
        }
        this.xCoord = x;
        this.yCoord = y;
        this.name = nom;
        this.amounts = amts;
        this.items = it;
        this.mods = md;
    }

    public int getX() {
        return this.xCoord;
    }

    public int getY() {
        return this.yCoord;
    }

    public int getNameLength() {
        return this.name.length;
    }

    public byte[] getName() {
        return this.name;
    }

    public byte[] getContents() {
        int empty = this.getEmptySlots();
        ByteBuffer outBuff = ByteBuffer.allocate(80 + (40 - empty) * 5);
        outBuff.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < 40; ++i) {
            outBuff.putShort(this.amounts[i]);
            if (this.amounts[i] == 0) continue;
            outBuff.putInt(this.items[i]);
            outBuff.put(this.mods[i]);
        }
        return outBuff.array();
    }

    public int getItemAt(int i) {
        if (i < 0 || i > 40) {
            return 0;
        }
        return this.items[i];
    }

    public byte[] getAllChestData() {
        int i;
        ByteBuffer outBuff = ByteBuffer.allocate(this.getChestDataSize());
        outBuff.order(ByteOrder.LITTLE_ENDIAN);
        outBuff.putInt(this.xCoord);
        outBuff.putInt(this.yCoord);
        outBuff.put((byte)this.name.length);
        for (i = 0; i < this.name.length; ++i) {
            outBuff.put(this.name[i]);
        }
        outBuff.putInt(40);
        for (i = 0; i < 40; ++i) {
            outBuff.putShort(this.amounts[i]);
            if (this.amounts[i] == 0) continue;
            outBuff.putInt(this.items[i]);
            outBuff.put(this.mods[i]);
        }
        return outBuff.array();
    }

    public int getChestDataSize() {
        int size = 13;
        size += this.name.length;
        int empty = this.getEmptySlots();
        return size += 2 * empty + 7 * (40 - empty);
    }

    private int getEmptySlots() {
        int slots = 0;
        for (int i = 0; i < this.amounts.length; ++i) {
            if (this.amounts[i] != 0) continue;
            ++slots;
        }
        return slots;
    }

    public void setContents(short[] amts, int[] it, byte[] md) {
        if (amts.length != 40 || it.length != 40 || md.length != 40) {
            throw new IllegalArgumentException();
        }
        this.amounts = amts;
        this.items = it;
        this.mods = md;
    }

    public boolean isEmpty() {
        return this.getEmptySlots() == 40;
    }

    public int getRarity() {
        for (int i = 0; i < TerrariaUtil.chestTypes.length; ++i) {
            for (int j = 0; j < TerrariaUtil.chestTypes[i].length; ++j) {
                if (this.items[0] != TerrariaUtil.chestTypes[i][j]) continue;
                return TerrariaUtil.chestRarities[i];
            }
        }
        return 0;
    }
}

